<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <title>CV Online - Shofie Sholeha</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">

    <style>
        * {
            font-family: 'Outfit', sans-serif;
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            background: #0f0f1e;
            position: relative;
            overflow-x: hidden;
        }

        body::before {
            content: '';
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: 
                radial-gradient(circle at 20% 50%, rgba(120, 119, 198, 0.3) 0%, transparent 50%),
                radial-gradient(circle at 80% 80%, rgba(255, 103, 132, 0.3) 0%, transparent 50%),
                radial-gradient(circle at 40% 20%, rgba(138, 122, 255, 0.2) 0%, transparent 50%);
            animation: gradient-shift 15s ease infinite;
            z-index: 0;
        }

        @keyframes gradient-shift {
            0%, 100% { opacity: 1; }
            50% { opacity: 0.8; }
        }

        .navbar-glass {
            background: rgba(15, 15, 30, 0.7);
            backdrop-filter: blur(20px);
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.3);
            padding: 20px 0;
            position: sticky;
            top: 0;
            z-index: 1000;
        }

        .navbar-brand {
            font-size: 1.8rem;
            font-weight: 900;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 50%, #f093fb 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            display: flex;
            align-items: center;
            gap: 12px;
            transition: all 0.4s ease;
            letter-spacing: -1px;
        }

        .navbar-brand::before {
            content: '✨';
            font-size: 2rem;
            animation: rotate-icon 3s ease-in-out infinite;
            -webkit-text-fill-color: initial;
        }

        @keyframes rotate-icon {
            0%, 100% { transform: rotate(0deg) scale(1); }
            50% { transform: rotate(180deg) scale(1.2); }
        }

        .navbar-brand:hover {
            transform: scale(1.05);
            filter: brightness(1.2);
        }

        .nav-link {
            color: rgba(255, 255, 255, 0.7) !important;
            font-weight: 600;
            padding: 12px 24px !important;
            margin: 0 6px;
            border-radius: 30px;
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
            overflow: hidden;
            font-size: 0.95rem;
            letter-spacing: 0.5px;
        }

        .nav-link::before {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 0;
            height: 0;
            border-radius: 50%;
            background: linear-gradient(135deg, #667eea, #764ba2);
            transition: all 0.5s ease;
            transform: translate(-50%, -50%);
            z-index: -1;
        }

        .nav-link:hover::before {
            width: 300px;
            height: 300px;
        }

        .nav-link:hover {
            color: white !important;
            transform: translateY(-3px);
            box-shadow: 0 10px 30px rgba(102, 126, 234, 0.4);
        }

        .nav-link.active {
            background: linear-gradient(135deg, #667eea, #764ba2);
            color: white !important;
            box-shadow: 0 8px 25px rgba(102, 126, 234, 0.5);
        }

        .btn-admin {
            background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
            color: white;
            border: none;
            padding: 12px 32px;
            border-radius: 30px;
            font-weight: 700;
            transition: all 0.4s ease;
            box-shadow: 0 8px 30px rgba(245, 87, 108, 0.4);
            display: flex;
            align-items: center;
            gap: 10px;
            font-size: 0.95rem;
            letter-spacing: 0.5px;
            position: relative;
            overflow: hidden;
        }

        .btn-admin::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.3), transparent);
            transition: left 0.5s ease;
        }

        .btn-admin:hover::before {
            left: 100%;
        }

        .btn-admin::after {
            content: '🔐';
            font-size: 1.2rem;
        }

        .btn-admin:hover {
            transform: translateY(-4px) scale(1.05);
            box-shadow: 0 12px 40px rgba(245, 87, 108, 0.6);
            color: white;
        }

        .btn-admin:active {
            transform: translateY(-2px) scale(1.02);
        }

        
        .navbar-toggler {
            border: 2px solid rgba(102, 126, 234, 0.5);
            padding: 10px 14px;
            border-radius: 12px;
            transition: all 0.3s ease;
        }

        .navbar-toggler:hover {
            border-color: #667eea;
            background: rgba(102, 126, 234, 0.1);
        }

        .navbar-toggler:focus {
            box-shadow: 0 0 0 0.3rem rgba(102, 126, 234, 0.3);
        }

        .navbar-toggler-icon {
            background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 30 30'%3e%3cpath stroke='rgba%28102, 126, 234, 1%29' stroke-linecap='round' stroke-miterlimit='10' stroke-width='2.5' d='M4 7h22M4 15h22M4 23h22'/%3e%3c/svg%3e");
        }

        
        .container-main {
            background: rgba(255, 255, 255, 0.03);
            backdrop-filter: blur(20px);
            border-radius: 40px;
            border: 1px solid rgba(255, 255, 255, 0.1);
            box-shadow: 
                0 20px 60px rgba(0, 0, 0, 0.3),
                inset 0 1px 0 rgba(255, 255, 255, 0.1);
            padding: 50px;
            margin-top: 40px;
            margin-bottom: 40px;
            position: relative;
            z-index: 1;
        }

        .particle {
            position: fixed;
            border-radius: 50%;
            pointer-events: none;
            z-index: 0;
            animation: float-particle 20s infinite ease-in-out;
        }

        .particle:nth-child(1) {
            width: 80px;
            height: 80px;
            background: radial-gradient(circle, rgba(102, 126, 234, 0.3), transparent);
            top: 10%;
            left: 10%;
            animation-delay: 0s;
        }

        .particle:nth-child(2) {
            width: 60px;
            height: 60px;
            background: radial-gradient(circle, rgba(245, 87, 108, 0.3), transparent);
            top: 60%;
            left: 80%;
            animation-delay: 5s;
        }

        .particle:nth-child(3) {
            width: 100px;
            height: 100px;
            background: radial-gradient(circle, rgba(138, 122, 255, 0.2), transparent);
            top: 80%;
            left: 20%;
            animation-delay: 10s;
        }

        @keyframes float-particle {
            0%, 100% {
                transform: translate(0, 0) scale(1);
            }
            25% {
                transform: translate(50px, -50px) scale(1.1);
            }
            50% {
                transform: translate(-30px, -80px) scale(0.9);
            }
            75% {
                transform: translate(40px, -20px) scale(1.05);
            }
        }

        
        @media (max-width: 991px) {
            .navbar-nav {
                padding-top: 20px;
                gap: 10px;
            }

            .nav-link {
                margin: 8px 0;
                text-align: center;
            }

            .btn-admin {
                margin-top: 20px;
                width: 100%;
                justify-content: center;
            }

            .container-main {
                padding: 30px 20px;
            }
        }

        @media (max-width: 768px) {
            .navbar-brand {
                font-size: 1.4rem;
            }

            .container-main {
                border-radius: 25px;
                margin-top: 25px;
            }
        }

        
        ::-webkit-scrollbar {
            width: 10px;
        }

        ::-webkit-scrollbar-track {
            background: #0f0f1e;
        }

        ::-webkit-scrollbar-thumb {
            background: linear-gradient(135deg, #667eea, #764ba2);
            border-radius: 10px;
        }

        ::-webkit-scrollbar-thumb:hover {
            background: linear-gradient(135deg, #764ba2, #f093fb);
        }
    </style>
</head>

<body>
    
    <div class="particle"></div>
    <div class="particle"></div>
    <div class="particle"></div>

    <nav class="navbar navbar-expand-lg navbar-glass">
        <div class="container">
            <a class="navbar-brand" href="<?= base_url('/') ?>">
                CV Shofie
            </a>

            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>

            <div class="collapse navbar-collapse" id="navbarNav">

            
                <ul class="navbar-nav me-auto">
                    <li class="nav-item">
                        <a class="nav-link <?= uri_string() == '' ? 'active' : '' ?>" href="<?= base_url('/') ?>">Home</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?= uri_string() == 'biodata' ? 'active' : '' ?>" href="<?= base_url('biodata') ?>">Biodata</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?= uri_string() == 'pendidikan' ? 'active' : '' ?>" href="<?= base_url('pendidikan') ?>">Pendidikan</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link <?= uri_string() == 'aktivitas' ? 'active' : '' ?>" href="<?= base_url('aktivitas') ?>">Aktivitas</a>
                    </li>
                </ul>

                <ul class="navbar-nav">
                    <li class="nav-item">
                        <a class="btn btn-admin" href="<?= base_url('auth/biodata') ?>">
                            Admin Panel
                        </a>
                    </li>
                </ul>

            </div>
        </div>
    </nav>

    <div class="container container-main">